define(['angular', 'app', 'page_service', 'PatientFHIRService'], function (angular, app) {
	"use strict";
	app.service('authenticationService',
		function ($http, $q, $window, $location, $rootScope, $injector, pageService, PatientFHIRService, localResourceDirectoryService) {
			var _auth = {},
				isAuthenticated,
				jwtCookieName = 'DNS      ',
				vamfJwtToken = {};

			_auth.deleteCookie = function (cookieName) {
				document.cookie = encodeURIComponent(cookieName)  + 'domain=' + document.domain + ';path=/;' + 'expires=' + new Date(0).toUTCString();
			};

			_auth.gotoLogoutWithRedirect = function () {
				localResourceDirectoryService.fetch().then(function (directory) {
					var logoutUrl = directory['users-logout'];
					window.open(logoutUrl, "_self");
				});
			};

			_auth.authorize = function () {
				localResourceDirectoryService.fetch().then(function(directory){
					var url = directory['users-login'] + '?redirect_uri=/fit-heart/';
					_auth.gotoLoginWithRedirect(url);
				})
			};

			_auth.gotoLoginWithRedirect = function (loginUrl) {
				window.location.href = loginUrl;
			};

			_auth.authenticate = function () {
				var deferred = $q.defer();
				var authenticated = _auth.isAuthenticated();
				if (!authenticated) {
					_auth.authorize();
					deferred.reject(authenticated);
				} else {
					deferred.resolve(authenticated);
				}

				return deferred.promise;
			};

			_auth.isAuthenticated = function () {
				return isAuthenticated;
			};

			_auth.checkAuthStatus = function () {
				if (request) {
					return request.promise;
				}
				var request = $q.defer();
				_auth.checkJwtToken().then(function (response) {
					isAuthenticated = response;

					if (isAuthenticated) {
						$injector.invoke(['connectionTimeoutService', function (connectionTimeoutService) {
							connectionTimeoutService.run();
						}]);
					}

					request.resolve(isAuthenticated);
				}, function (error) {
					request.reject(error);
				});

				return request.promise;
			};


			_auth.checkJwtToken = function () {
				if (done) {
					return done.promise;
				}
				var done = $q.defer();
				var validToken = false;
				vamfJwtToken = getCookie();
				if (vamfJwtToken) {
					// get patient payload from cookie
					var tokenData = parseJwt(vamfJwtToken)
					if (tokenData.authenticated) {
						validToken = true;
						PatientFHIRService.setPatientContext(tokenData.patient).then(function (success) {
							if (!success) {
								console.error("There was an error while setting PatientContext");
							}
							done.resolve(validToken);
						}, function (error) {
							done.reject(error);
						});
					} else {
						done.reject(validToken);
					}
				} else {
					done.reject({error: 'empty token'});
				}

				return done.promise;
			};

			_auth.getParsedToken = function () {
				var tokenData = {};
				vamfJwtToken = getCookie();
				if (vamfJwtToken) {
					tokenData = parseJwt(vamfJwtToken);
				}

				return tokenData;
			};

			// helper functions
			var getCookie = function () {
				var cookieName = jwtCookieName;
				var b = document.cookie.match('(^|;)\\s*' + cookieName + '\\s*=\\s*([^;]+)');
				return b ? b.pop() : '';
			}
			var parseJwt = function (token) {
				var base64String = token.split('.')[1];
				var base64 = base64String.split('-').join('+').split('_').join('/');
				return JSON.parse(window.atob(base64));
			};

			_auth.parseJwt = parseJwt;

			return _auth;
		});
});
